class RideServiceResponse {
  RideServiceResponse({
    this.message,
    this.data,});

  RideServiceResponse.fromJson(dynamic json) {
    message = json['message'];
    data = json['data'] != null ? Data.fromJson(json['data']) : null;
  }
  String? message;
  Data? data;
  RideServiceResponse copyWith({  String? message,
    Data? data,
  }) => RideServiceResponse(  message: message ?? this.message,
    data: data ?? this.data,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['message'] = message;
    if (data != null) {
      map['data'] = data?.toJson();
    }
    return map;
  }

}

class Data {
  Data({
    this.servicesList,
    this.distance,
    this.duration,});

  Data.fromJson(dynamic json) {
    if (json['services'] != null) {
      servicesList = [];
      json['services'].forEach((v) {
        servicesList?.add(Services.fromJson(v));
      });
    }
    distance = json['distance'];
    duration = json['duration'];
  }
  List<Services>? servicesList;
  String? distance;
  String? duration;
  Data copyWith({  List<Services>? services,
    String? distance,
    String? duration,
  }) => Data(  servicesList: services ?? servicesList,
    distance: distance ?? this.distance,
    duration: duration ?? this.duration,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (servicesList != null) {
      map['services'] = servicesList?.map((v) => v.toJson()).toList();
    }
    map['distance'] = distance;
    map['duration'] = duration;
    return map;
  }

}

class Services {
  Services({
    this.id,
    this.name,
    this.logo,
    this.personCapacity,
    this.minimumFee,
    this.serviceFare,
    this.baseFare,
    this.costAfterCoupon,
    this.isCouponApplicable,
    this.additionalFee,
    this.totalFare,});

  Services.fromJson(dynamic json) {
    id = json['id'];
    name = json['name'];
    logo = json['logo'];
    personCapacity = json['person_capacity'];
    minimumFee = json['minimum_fee'];
    serviceFare = json['service_fare'];
    baseFare = json['base_fare'];
    costAfterCoupon = json['cost_after_coupon'];
    isCouponApplicable = json['is_coupon_applicable'];
    additionalFee = json['additional_fee'];
    totalFare = json['total_fare'];
  }
  num? id;
  String? name;
  String? logo;
  num? personCapacity;
  num? minimumFee;
  num? serviceFare;
  num? baseFare;
  num? costAfterCoupon;
  bool? isCouponApplicable;
  num? additionalFee;
  num? totalFare;
  Services copyWith({  num? id,
    String? name,
    String? logo,
    num? personCapacity,
    num? minimumFee,
    num? serviceFare,
    num? baseFare,
    num? costAfterCoupon,
    bool? isCouponApplicable,
    num? additionalFee,
    num? totalFare,
  }) => Services(  id: id ?? this.id,
    name: name ?? this.name,
    logo: logo ?? this.logo,
    personCapacity: personCapacity ?? this.personCapacity,
    minimumFee: minimumFee ?? this.minimumFee,
    serviceFare: serviceFare ?? this.serviceFare,
    baseFare: baseFare ?? this.baseFare,
    costAfterCoupon: costAfterCoupon ?? this.costAfterCoupon,
    isCouponApplicable: isCouponApplicable ?? this.isCouponApplicable,
    additionalFee: additionalFee ?? this.additionalFee,
    totalFare: totalFare ?? this.totalFare,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['name'] = name;
    map['logo'] = logo;
    map['person_capacity'] = personCapacity;
    map['minimum_fee'] = minimumFee;
    map['service_fare'] = serviceFare;
    map['base_fare'] = baseFare;
    map['cost_after_coupon'] = costAfterCoupon;
    map['is_coupon_applicable'] = isCouponApplicable;
    map['additional_fee'] = additionalFee;
    map['total_fare'] = totalFare;
    return map;
  }

}